fetch('assets/connection/dados_grafico.php')
    .then(response => response.json())
    .then(data => {
        const quantidade = data.map(item => item.quantidade);
        const tipos = data.map(item => item.tipo);

        const ctx = document.getElementById('teste').getContext('2d');
        new Chart(ctx, {
            type: 'bar',
            data: {
                labels: tipos,
                datasets: [{
                    label: 'Quantidade',
                    data: quantidade,
                    backgroundColor: 'rgba(78, 115, 223, 0.5)',
                    borderColor: 'rgba(78, 115, 223, 1)',
                    borderWidth: 1
                }]
            },
            options: {
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });
    });
